#!/usr/bin/bash

version=${1:-1.8.2}
url="https://github.com/thomiceli/opengist/releases/download/v$version/opengist$version-linux-amd64.tar.gz"
tar_file=${url##*/}
binary="opengist$version-linux-amd64"

# create user
if ! id -u opengist; then
    useradd -mr -d /var/lib/opengist opengist

    ## create config dir
    mkdir -p /etc/opengist

    ## fix perms
    chown -R opengist:opengist /etc/opengist
    chmod 2770 $_
fi

# download
curl -LO "$url"

# extract binary
tar -xavf "$tar_file" -C /usr/local/bin --strip-components=1 --transform="s@\$@1.8.2-linux-amd64@" opengist/opengist

# extract config
tar -xavf "$tar_file" -C /etc/opengist --strip-components=1 opengist/config.yml

# symlink
cd /usr/local/bin
ln -s $binary opengist
cd -

# create systemd service
cat << EOF > /etc/systemd/system/opengist.service
[Unit]
Description=opengist Server
After=network.target
Requires=nginx.service

[Service]
Type=simple
User=opengist
Group=opengist
ExecStart=/usr/local/bin/opengist --config /etc/opengist/config.yml
Restart=on-failure

[Install]
WantedBy=multi-user.target
EOF

# activate service
systemctl daemon-reload
systemctl enable --now opengist