#!/usr/bin/bash

# Description:
# This script is for installing opengist. To use it, you need to execute it with a version as an argument
#
# For example:
#
#     opengist-install 1.18.2

# functions
# example: rm / || die 'It didn't work!' 2
die() {
    local message=$1
    local code=$2

    echo -e "Error: $1"
    exit $2
}


version=$1
url="https://github.com/thomiceli/opengist/releases/download/v$version/opengist$version-linux-amd64.tar.gz"
tar_file=${url##*/}
binary="opengist$version-linux-amd64"

# check if version was provided
if [[ -z $version ]]; then
    die "You didn't provide a version to install. Please, provide one similar to: a.b.c" 1
fi

# create user
if ! id -u opengist; then
    useradd -mr -d /var/lib/opengist opengist

    ## create config dir
    mkdir -p /etc/opengist
fi

# download
curl -LO "$url"

# extract binary
tar -xavf "$tar_file" -C /usr/local/bin --strip-components=1 --transform="s@\$@1.8.2-linux-amd64@" opengist/opengist

# extract config
tar -xavf "$tar_file" -C /etc/opengist --strip-components=1 opengist/config.yml

# symlink
cd /usr/local/bin
ln -s $binary opengist
cd -

# fix perms
chown -R opengist:opengist /etc/opengist
chmod 2770 $_
chmod 660 $_/*
chmod -R o-rwx /var/lib/opengist

# create systemd service
cat << EOF > /etc/systemd/system/opengist.service
[Unit]
Description=opengist Server
After=network.target

[Service]
Type=simple
User=opengist
Group=opengist
ExecStart=/usr/local/bin/opengist --config /etc/opengist/config.yml
Restart=on-failure

[Install]
WantedBy=multi-user.target
EOF

# activate service
systemctl daemon-reload
systemctl enable --now opengist